#include "std_includes.h"

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;

template<typename T>
void f(T& x, const T& p, const double& eps) {
  while (abs(x*x-p)>eps) x=x-(x*x-p)/(2*x);
}

template<>
void f(DCO_T &x, const DCO_T& p, const double& eps) {
  f(dco::value(x),dco::value(p),eps);
  dco::derivative(x)=dco::derivative(p)/(2*dco::value(x));
}

void driver (double& xv, double& xt, const double& pv, const double& pt, const double eps) {
  DCO_T x=xv,p=pv;
  dco::derivative(x)=xt; dco::derivative(p)=pt;
  f(x,p,eps); 
  xv=dco::value(x); xt=dco::derivative(x);
}

int main(int c, char *v[]) {
  assert(c==2);
  double xv=1,pv=atof(v[1]),xt=0,pt=1;
  const double eps=1e-12;
  driver(xv,xt,pv,pt,eps);
  cout << "x=" << xv << endl;
  cout << "dxdp=" << xt << endl;
  return 0;
}
