#include "std_includes.h"

#include "dco.hpp"
typedef dco::ga1s<double> DCO_AM;
typedef DCO_AM::type DCO_A;
typedef DCO_AM::tape_t DCO_AM_TAPE;
typedef DCO_AM::external_adjoint_object_t DCO_AM_EAO;

template<typename T>
void newton(T& x, const T& p, const double& eps) {
  while (abs(x*x-p)>eps) x=x-(x*x-p)/(2*x);
}

void adjoint_newton(DCO_AM_EAO *D) {
  const double &xv = D->read_data<double>();
  double xa, pa;
  xa=D->get_output_adjoint();
  pa=xa/(2*xv);
  D->increment_input_adjoint(pa);
}

template<>
void newton(DCO_A &x, const DCO_A &p, const double& eps) {
  DCO_AM_EAO *D=DCO_AM::global_tape->create_callback_object<DCO_AM_EAO>();
  double pv=D->register_input(p);
  double xv=dco::value(x);
  newton(xv,pv,eps);
  x=D->register_output(xv);
  D->write_data(xv);
  DCO_AM::global_tape->insert_callback<DCO_AM_EAO>(adjoint_newton,D);
}

void driver (double& xv, const double& xa, 
    const double& pv, double& pa, const double& eps) {
  DCO_AM::global_tape=DCO_AM_TAPE::create();
  DCO_A x=xv,p=pv;
  DCO_AM::global_tape->register_variable(p);
  newton(x,p,eps); 
  xv=dco::value(x);
  DCO_AM::global_tape->register_output_variable(x);
  dco::derivative(x)=xa;
  cerr << dco::size_of(DCO_AM::global_tape) << "B" << endl;
  DCO_AM::global_tape->interpret_adjoint();
  pa=dco::derivative(p);
  DCO_AM_TAPE::remove(DCO_AM::global_tape);
}

int main(int c, char* v[]) {
  assert(c==2);
  double xv=1,pv=atof(v[1]),xa=1,pa=0;
  const double eps=1e-12;
  driver(xv,xa,pv,pa,eps);
  cout << "x=" << xv << endl;
  cout << "dxdp=" << pa << endl;
  return 0;
}
