#include "std_includes.h"

template<typename T>
void f_t(T& x, T& xt, 
    const vector<T>& p, vector<T>& pt,
    const vector<vector<double>>& dW) {
  int m=dW.size(), n=dW[0].size();
  T s=0, st=0, x0=x, x0t=xt; double dt=1./n, t;
  for (int j=0;j<m;j++) {
    t=0;
    for (int i=0;i<n;i++) {
      xt+=dt*sin(x*t)*pt[i]
          +dt*p[i]*t*cos(x*t)*xt
          +cos(x*t)*sqrt(dt)*dW[j][i]*pt[i]
          -p[i]*t*sin(x*t)*sqrt(dt)*dW[j][i]*xt;
      x+=dt*p[i]*sin(x*t)+p[i]*cos(x*t)*sqrt(dt)*dW[j][i];
      t+=dt;
    } 
    st+=xt; s+=x; 
    xt=x0t; x=x0;
  }   
  xt=st/m; x=s/m;
} 

vector<double> driver(double& x, const vector<double>& p,
    const vector<vector<double>>& dW) {
  int n=dW[0].size();
  vector<double> g(n+1,0);
  double x0=x, xt=1; vector<double> pt(n,0);
  f_t(x,xt,p,pt,dW);
  g[0]=xt;
  for (int i=0;i<n;i++) {
    x=x0; xt=0; pt[i]=1;
    f_t(x,xt,p,pt,dW);
    g[i+1]=xt;
    pt[i]=0;
  }
  return g;
}  

int main(int c, char* v[]) {
  assert(c==3); int m=atoi(v[1]), n=atoi(v[2]);

  const double x0=1;
  vector<double> p(n,1); 

  default_random_engine generator;
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> dW(m,vector<double>(n,1));
  for (int i=0;i<m;i++)
    for (int j=0;j<n;j++)
      dW[i][j]=distribution(generator);

  double x=x0;
  vector<double> g=driver(x,p,dW);
  cout << "dx/dx0=" << g[0] << endl;
  for (int i=0;i<n;i++) 
    cout << "dx/dp[" << i << "]=" << g[i+1] << endl;
  return 0;
}
