#include "std_includes.h"
#include "f.h"

template<typename T>
vector<T> driver(T& x, vector<T>& p,
    const vector<vector<double>>& dW) {
  int n=dW[0].size();
  vector<T> g(n+1,0);
  double x0=x; 
  f(x,p,dW);
  double h=sqrt(DBL_EPSILON);
  double xp=x0+h;
  f(xp,p,dW);
  g[0]=(xp-x)/h;
  for (int i=0;i<n;i++) {
    xp=x0; p[i]+=h; f(xp,p,dW); g[i+1]=(xp-x)/h; p[i]-=h;
  }
  return g;
}  

int main(int c, char* v[]) {
  assert(c==3); int m=atoi(v[1]), n=atoi(v[2]);

  const double x0=1;
  vector<double> p(n,1); 

  default_random_engine generator;
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> dW(m,vector<double>(n,1));
  for (int i=0;i<m;i++)
    for (int j=0;j<n;j++)
      dW[i][j]=distribution(generator);

  double x=x0;
  vector<double> g=driver(x,p,dW);
  cout << "dx/dx0=" << g[0] << endl;
  for (int i=0;i<n;i++) 
    cout << "dx/dp[" << i << "]=" << g[i+1] << endl;
  return 0;
}

