#include "std_includes.h" 

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;
typedef dco::gt1s<DCO_T>::type DCO_TT;

#include "f.h"

vector<vector<double>> driver(
    double& xv, const vector<double> &pv, 
    const vector<vector<double>>& dW) {
  int n=pv.size();
  vector<DCO_TT> p(n); dco::passive_value(p)=pv;
  vector<vector<double>> ddxdpp(n,vector<double>(n,0));
  for (int i=0;i<n;i++) {
    dco::derivative(dco::value(p[i]))=1;
    for (int j=0;j<=i;j++) {
      dco::value(dco::derivative(p[j]))=1;
      DCO_TT x=xv;
      f(x,p,dW);
      ddxdpp[i][j]=dco::derivative(dco::derivative(x));
      dco::value(dco::derivative(p[j]))=0;
    }
    dco::derivative(dco::value(p[i]))=0;
  }
  return ddxdpp;
}

int main(int c, char* v[]) {
  assert(c==3);
  int m=atoi(v[1]), n=atoi(v[2]);

  double x=1;
  vector<double> p(n,1); 

  default_random_engine generator;
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> dW(m,vector<double>(n,1));
  for (int i=0;i<m;i++)
    for (int j=0;j<n;j++)
      dW[i][j]=distribution(generator);

  vector<vector<double>> ddxdpp=driver(x,p,dW);
  for (int i=0;i<n;i++) 
    for (int j=0;j<=i;j++) 
      cout << "ddx/dpp[" << i << "][" << j << "]="
          << ddxdpp[i][j] << endl;
  return 0;
}
