#include "std_includes.h" 

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;
typedef dco::ga1s<DCO_T> DCO_TAM;
typedef DCO_TAM::type DCO_TA;
typedef DCO_TAM::tape_t DCO_TAM_TAPE;
typedef DCO_TAM_TAPE::position_t DCO_TAM_TAPE_POS;

#include "f.h"

vector<vector<double>> driver(
    double& xv, const vector<double> &pv, 
    const vector<vector<double>>& dW) {
  int n=pv.size();
  vector<DCO_TA> p(n); dco::passive_value(p)=pv;
  vector<vector<double>> ddxdpp(n,vector<double>(n,0));
  DCO_TAM::global_tape=DCO_TAM_TAPE::create();
  DCO_TAM::global_tape->register_variable(p);
  DCO_TAM_TAPE_POS tpos=DCO_TAM::global_tape->get_position();
  for (int i=0;i<n;i++) {
    dco::derivative(dco::value(p[i]))=1;
    DCO_TA x=xv;
    f(x,p,dW);
    dco::value(dco::derivative(x))=1;
    DCO_TAM::global_tape->interpret_adjoint_and_reset_to(tpos);
    for (int j=0;j<=i;j++)
      ddxdpp[i][j]=dco::derivative(dco::derivative(p[j]));
    for (int j=0;j<n;j++) {
      dco::derivative(dco::derivative(p[j]))=0;
      dco::value(dco::derivative(p[j]))=0;
    }
    dco::derivative(dco::value(p[i]))=0;
  }
  DCO_TAM_TAPE::remove(DCO_TAM::global_tape);
  return ddxdpp;
}

int main(int c, char* v[]) {
  assert(c==3);
  int m=atoi(v[1]), n=atoi(v[2]);

  double x=1;
  vector<double> p(n,1); 

  default_random_engine generator;
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> dW(m,vector<double>(n,1));
  for (int i=0;i<m;i++)
    for (int j=0;j<n;j++)
      dW[i][j]=distribution(generator);

  vector<vector<double>> ddxdpp=driver(x,p,dW);
  for (int i=0;i<n;i++) 
    for (int j=0;j<=i;j++) 
      cout << "ddx/dpp[" << i << "][" << j << "]="
          << ddxdpp[i][j] << endl;
  return 0;
}
