#include "std_includes.h"

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;

#include "f.h"

vector<double> driver(double& xv, vector<double>& pv,
    const vector<vector<double>>& dW) {
  int n=dW[0].size();
  vector<double> g(n+1,0);
  DCO_T x0=xv;  
  vector<DCO_T> p(n); dco::value(p)=pv; 
  DCO_T x=x0;  
  dco::derivative(x)=1;
  f(x,p,dW);
  g[0]=dco::derivative(x);
  for (int i=0;i<n;i++) {
    x=x0;
    dco::derivative(p[i])=1;
    f(x,p,dW);
    g[i+1]=dco::derivative(x);
    dco::derivative(p[i])=0;
  }
  return g;
}  

int main(int c, char* v[]) {
  assert(c==3); int m=atoi(v[1]), n=atoi(v[2]);

  const double x0=1;
  vector<double> p(n,1); 

  default_random_engine generator;
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> dW(m,vector<double>(n,1));
  for (int i=0;i<m;i++)
    for (int j=0;j<n;j++)
      dW[i][j]=distribution(generator);

  double x=x0;
  vector<double> g=driver(x,p,dW);
  cout << "dx/dx0=" << g[0] << endl;
  for (int i=0;i<n;i++) 
    cout << "dx/dp[" << i << "]=" << g[i+1] << endl;
  return 0;
}
