#include "std_includes.h"
using namespace std;

template<typename T>
void f_tt(
    const vector<T>& x, 
    const vector<T>& x_t, 
    const vector<T>& xt, 
    const vector<T>& xt_t, 
    T& y, 
    T& y_t, 
    T& yt,
    T& yt_t
) {
  assert(x.size()>0);
  yt_t=xt_t[0]; 
  yt=xt[0]; 
  y_t=x_t[0];
  y=x[0];
  for (size_t i=1;i<x.size();i++) { 
    yt_t=yt_t*x[i]+yt*x_t[i]+y_t*xt[i]+y*xt_t[i]; 
    yt=yt*x[i]+y*xt[i]; 
    y_t=y_t*x[i]+y*x_t[i]; 
    y*=x[i]; 
  }
}

void driver(vector<double>& x, double &y, vector<double>& g, vector<vector<double>>& H) {
  vector<double> x_t(x.size(),0);
  vector<double> xt(x.size(),0);
  vector<double> xt_t(x.size(),0);
  double yt, y_t;
  for (size_t i=0;i<x.size();i++) {
    xt[i]=1;
    for (size_t j=0;j<x.size();j++) {
      x_t[j]=1;
      f_tt(x,x_t,xt,xt_t,y,y_t,yt,H[i][j]);
      x_t[j]=0;
    }
    g[i]=yt;
    xt[i]=0;
  }
}  

int main(int c, char* v[]) {
  assert(c==2); int n=atoi(v[1]); assert(n>0);
  vector<double> x(n), g(n); 
  double y;
  vector<vector<double>> H(n,vector<double>(n)); 
  for (int i=0;i<n;i++) x[i]=cos(static_cast<double>(i));
  driver(x,y,g,H);
  cout << y << endl;
  for (int i=0;i<n;i++) cout << g[i] << endl;
  for (int i=0;i<n;i++) {
    for (int j=0;j<n;j++) cout << H[i][j] << " ";
    cout << endl;
  }
  return 0;
}
