#include "std_includes.h"
using namespace std;

template<typename T>
void f_a_t(
    const vector<T>& x, 
    const vector<T>& x_t, 
    vector<T>& x_a, 
    vector<T>& x_a_t, 
    T& y, 
    T& y_t, 
    T& y_a,
    T& y_a_t
) {
  assert(x.size()>0);
  stack<T> tbr_t;
  stack<T> tbr;
  y_t=x_t[0];
  y=x[0];
  for (size_t i=1;i<x.size();i++) { 
    tbr_t.push(y_t); 
    tbr.push(y); 
    y_t=y_t*x[i]+y*x_t[i]; 
    y*=x[i]; 
  }
  double ys_t=y_t;
  double ys=y;
  for (size_t i=x.size()-1;i>0;i--) { 
    y_t=tbr_t.top(); tbr_t.pop(); 
    y=tbr.top(); tbr.pop(); 
    x_a_t[i]+=y_t*y_a+y*y_a_t; 
    x_a[i]+=y*y_a; 
    y_a_t=x_t[i]*y_a+x[i]*y_a_t; 
    y_a=x[i]*y_a; 
  }
  x_a_t[0]=y_a_t; 
  x_a[0]=y_a; 
  y_a_t=0;
  y_a=0;
  y_t=ys_t;
  y=ys;
}

void driver(vector<double>& x, double &y, vector<double>& g, vector<vector<double>>& h) {
  int n=x.size();
  for (int i=0;i<n;i++) {
    vector<double> x_t(n,0), x_a(n,0);
    x_t[i]=1;
    double y_a=1,y_a_t=0;
    f_a_t(x,x_t,x_a,h[i],y,g[i],y_a,y_a_t);
  }
}  

int main(int c, char* v[]) {
  assert(c==2); int n=atoi(v[1]); assert(n>0);
  vector<double> x(n), g(n); 
  double y;
  vector<vector<double>> H(n,vector<double>(n)); 
  for (int i=0;i<n;i++) x[i]=cos(static_cast<double>(i));
  driver(x,y,g,H);
  cout << y << endl;
  for (int i=0;i<n;i++) cout << g[i] << endl;
  for (int i=0;i<n;i++) {
    for (int j=0;j<n;j++) cout << H[i][j] << " ";
    cout << endl;
  }
  return 0;
}
