#include "std_includes.h"
using namespace std;

template<typename T>
void f_t(const vector<T>& x, const vector<T>& x_t, T& y, T& y_t) {
  assert(x.size()>0);
  y_t=x_t[0]; y=x[0];
  for (size_t i=1;i<x.size();i++) { y_t=y_t*x[i]+y*x_t[i]; y*=x[i]; }
}

void driver(vector<double>& x, double &y, vector<double>& g) {
  vector<double> x_t(x.size(),0);
  for (size_t i=0;i<x.size();i++) {
    x_t[i]=1;
    f_t(x,x_t,y,g[i]);
    x_t[i]=0;
  }
}  

int main(int c, char* v[]) {
  assert(c==2); int n=atoi(v[1]); assert(n>0);
  vector<double> x(n), g(n); double y;
  for (int i=0;i<n;i++) x[i]=cos(static_cast<double>(i));
  driver(x,y,g);
  cout << y << endl;
  for (int i=0;i<n;i++) cout << g[i] << endl;
  return 0;
}
