# include "std_includes.h"
# include "f.h"
using namespace std;

void fg(vector<double>& x, double& y, vector<double>& g) {
  double d,yp,ym;
  for (size_t i=0;i<x.size();i++) {
    d=(x[i]<1) ? sqrt(sqrt(DBL_EPSILON)) : sqrt(sqrt(DBL_EPSILON))*abs(x[i]);  
    x[i]+=d;
    f(x,yp);
    x[i]-=2*d;
    f(x,ym);
    g[i]=(yp-ym)/(2*d);
    x[i]+=d;
  }
  f(x,y);
}  

void fgh(vector<double>& x, double& y, vector<double>& g, vector<vector<double>>& h) {
  double d;
  vector<double> gp(x.size()),gm(x.size());
  for (size_t i=0;i<x.size();i++) {
    d=(x[i]<1) ? sqrt(sqrt(DBL_EPSILON)) : sqrt(sqrt(DBL_EPSILON))*abs(x[i]);  
    x[i]+=d;
    fg(x,y,gp);
    x[i]-=2*d;
    fg(x,y,gm);
    for (size_t j=0;j<x.size();j++) 
    h[i][j]=(gp[j]-gm[j])/(2*d);
    x[i]+=d;
  }
  fg(x,y,g);
}  

int main(int c, char* v[]) {
  assert(c==2); int n=atoi(v[1]); assert(n>0);
  vector<double> x(n), g(n); double y;
  vector<vector<double>> h(n,vector<double>(n));
  for (int i=0;i<n;i++) x[i]=cos(static_cast<double>(i));
  fgh(x,y,g,h);
  cout << y << endl;
  for (int i=0;i<n;i++) cout << g[i] << endl;
  for (int i=0;i<n;i++) {
    for (int j=0;j<n;j++) cout << h[i][j] << " ";
    cout << endl;
  }
  return 0;
}
