#include "std_includes.h"
#include "f.h"

template <typename T>
inline void path_calc_t(
    const int path,
    vector<T>& L,
    vector<T>& L_t,
    const vector<vector<double>>& Z
) {
  for(int j=0;j<m;j++) {
    double aux1=sqrt(delta)*Z[path][j];
    T S_t=0.0; T S=0.0;
    for (int i=j+1;i<n;i++) {
      double aux2=delta*sigma[i-j-1];
      S_t+=(aux2/(1+delta*L[i])-delta*aux2*L[i]
           /((1+delta*L[i])*(1+delta*L[i])))*L_t[i];
      S+=(aux2*L[i])/(1.0+delta*L[i]);
      // L[i]=L[i]*exp(aux2*S+sigma[i-j-1]*(aux1-0.5*aux2));
      T t1_t=aux2*exp(aux2*S+sigma[i-j-1]*(aux1-0.5*aux2))*S_t;
      T t1=exp(aux2*S+sigma[i-j-1]*(aux1-0.5*aux2));
      L_t[i]=L_t[i]*t1+L[i]*t1_t;
      L[i]=L[i]*t1;
    }
  }
}

template <typename T>
inline void portfolio_t( 
    const vector<T>& L, const vector<T>& L_t, T& P, T& P_t) {
  vector<T> B(n),B_t(n),S(n),S_t(n);
  T b_t=0.0; T b=1.0;
  T s_t=0.0; T s=0.0;
  for (int j=m;j<n;j++) {
    b_t=b_t/(1.0+delta*L[j])-delta*b*L_t[j]
        /((1.0+delta*L[j])*(1.0+delta*L[j]));
    b=b/(1.0+delta*L[j]);
    B_t[j]=b_t;
    B[j]=b;
    s_t=s_t+delta*b_t;
    s=s+delta*b;
    S_t[j]=s_t;
    S[j]=s;
  }
  P_t=0; P=0;
  for (int i=0;i<no;i++){
    int j=maturities[i]+m-1;
    T swapval_t=B_t[j]+swaprates[i]*S_t[j];
    T swapval=B[j]+swaprates[i]*S[j]-1.0;
    if (swapval<0) {
      P_t+=-100.0*swapval_t;
      P+=-100.0*swapval;
    }
  }
  for (int i=0;i<m;i++) {
    P_t=P_t/(1.0+delta*L[i])-delta*P*L_t[i]
        /((1.0+delta*L[i])*(1.0+delta*L[i]));
    P=P/(1.0+delta*L[i]);
  }
}

template<typename T>
inline void f(const vector<T>& L, const vector<T>& L_t, 
    T& P, T& P_t, const vector<vector<double>>& Z) {
  T Ps_t=0;
  T Ps=0;
  for (int j=0;j<p;j++) {
    vector<T> Lc_t(L_t);
    vector<T> Lc(L);
    path_calc_t(j,Lc,Lc_t,Z);
    portfolio_t(Lc,Lc_t,P,P_t);
    Ps_t+=P_t; Ps+=P;
  }
  P_t=Ps_t/p; P=Ps/p;
}


int main() {
  vector<double> L(n,0.05); double P=0;
  vector<double> L_t(n,0); double P_t=0;
  srand(0); default_random_engine generator(0);
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> Z(p,vector<double>(m));
  for (int k=0;k<n;k++) {
    generator.seed(0);
    for (int j=0;j<p;j++)
      for (int i=0;i<m;i++)
        Z[j][i]=0.3+distribution(generator);
    for (int i=0;i<n;i++) { L[i]=0.05; L_t[i]=0.0; }
    L_t[k]=1.0;
    f(L,L_t,P,P_t,Z);
    cout << "dPdL[" << k << "]=" << P_t << endl;
  }
  return 0;
}
