#include "f.h"

enum Mode { AUGMENTED_PRIMAL, SPLIT_ADJOINT };

stack<double> tbr_d;
stack<int> tbr_i;
stack<int> tbr_f;

template <typename T>
void a_path_calc(
    Mode mode,
    vector<T>& L, 
    vector<T>& a_L, 
    const vector<double>& Z
) {
  double aux1=0,aux2=0; 
  T S=0, a_S=0;
  switch (mode) {
    case AUGMENTED_PRIMAL:
      for(int j=0;j<m;j++) {
        tbr_d.push(aux1);
        aux1=sqrt(delta)*Z[j];
        tbr_d.push(S);
        S=0;
        for (int i=j+1;i<n;i++) {
          tbr_d.push(aux2);
          aux2=delta*sigma[i-j-1];
          tbr_d.push(S);
          S+=(aux2*L[i])/(1.0+delta*L[i]);
          tbr_d.push(L[i]);
          L[i]=L[i]*exp(aux2*S+sigma[i-j-1]*(aux1-0.5*aux2));
        }
      }
      tbr_d.push(aux1);
      tbr_d.push(aux2);
      tbr_d.push(S);
      break;
    case SPLIT_ADJOINT:
      a_S=0;
      S=tbr_d.top(); tbr_d.pop();
      aux2=tbr_d.top(); tbr_d.pop();
      aux1=tbr_d.top(); tbr_d.pop();
      for(int j=m-1;j>=0;j--) {
        for (int i=n-1;i>=j+1;i--) {
          L[i]=tbr_d.top(); tbr_d.pop();
          a_S+=aux2*L[i]*exp(aux2*S+sigma[i-j-1]*(aux1-0.5*aux2))*a_L[i];
          a_L[i]=exp(aux2*S+sigma[i-j-1]*(aux1-0.5*aux2))*a_L[i];
          S=tbr_d.top(); tbr_d.pop();
          a_L[i]+=(aux2/(1+L[i]*delta)-delta*aux2*L[i]
                  /((1+L[i]*delta)*(1+L[i]*delta)))*a_S;
          aux2=tbr_d.top(); tbr_d.pop();
        }
        a_S=0;
        S=tbr_d.top(); tbr_d.pop();
        aux1=tbr_d.top(); tbr_d.pop();
      }
      break;
  }
}

template <typename T>
void a_portfolio(
    Mode mode,
    const vector<T>& L, 
    vector<T>& a_L, 
    T& P, 
    T& a_P 
) {
  vector<T> B(n,0),S(n,0);
  T swapval=0,b=0,s=0;
  T a_swapval=0,a_b=0,a_s=0;
  vector<T> a_B(n,0),a_S(n,0);
  switch (mode) {
    case AUGMENTED_PRIMAL:
      b=1.0;
      s=0.0;
      for (int j=m;j<n;j++) {
        tbr_d.push(b);
        b=b/(1.0+delta*L[j]);
        B[j]=b;
        s=s+delta*b;
        S[j]=s;
      }
      P=0;
      for (int i=0;i<no;i++){
        int j=maturities[i]+m-1;
        tbr_i.push(j);
        swapval=B[j]+swaprates[i]*S[j]-1.0;
        if (swapval<0) { 
          P+=-100.0*swapval;
          tbr_f.push(1);
        } else tbr_f.push(0);
      }
      for (int i=0;i<m;i++) {
        tbr_d.push(P);
        P=P/(1.0+delta*L[i]);
      }
      tbr_d.push(b);
      break;
    case SPLIT_ADJOINT:
      b=tbr_d.top(); tbr_d.pop();
      for (int i=m-1;i>=0;i--) {
        P=tbr_d.top(); tbr_d.pop();
        a_L[i]+=-P*a_P*delta/((1.0+delta*L[i])*(1.0+delta*L[i])); 
        a_P=a_P/(1.0+delta*L[i]);
      }
      for (int i=no-1;i>=0;i--) {
        if (tbr_f.top()) a_swapval+=-100.0*a_P;
        tbr_f.pop();
        int j=tbr_i.top(); tbr_i.pop();
        a_B[j]+=a_swapval;
        a_S[j]+=swaprates[i]*a_swapval; a_swapval=0.0;
      }
      a_P=0.0;
      for (int j=n-1;j>=m;j--) {
        a_s+=a_S[j]; a_S[j]=0;
        a_b+=delta*a_s;
        a_b+=a_B[j]; a_B[j]=0;
        b=tbr_d.top(); tbr_d.pop();
        a_L[j]+=-delta*b*a_b/((1.0+delta*L[j])*(1.0+delta*L[j]));
        a_b=a_b/(1.0+delta*L[j]);
      }
      a_b=0.0;
      a_s=0.0;
      break;
  }
}

int main() {
  vector<double> Z(n,0),L(n,0),a_L(n,0),Li(n,0.05),a_Li(n,0);
  double P=0,a_P=0;
  default_random_engine generator(0);
  normal_distribution<double> distribution(0.0,1.0);

  for (int j=0;j<p;j++) {
    for (int i=0;i<m;i++) 
      Z[i]=0.3+distribution(generator);
    for (int i=0;i<n;i++) L[i]=Li[i]; 
    a_path_calc(AUGMENTED_PRIMAL,L,a_L,Z);
    a_portfolio(AUGMENTED_PRIMAL,L,a_L,P,a_P);
    a_P=1.0/p;
    a_portfolio(SPLIT_ADJOINT,L,a_L,P,a_P);
    a_path_calc(SPLIT_ADJOINT,L,a_L,Z);
    for (int i=0;i<n;i++) { a_Li[i]+=a_L[i]; a_L[i]=0; }
  }
  for (int i=0;i<n;i++) 
    cout << "dPdL[" << i << "]=" << a_Li[i] << endl;
  return 0;
}
