#include "std_includes.h"
#include "f.h"

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;
typedef dco::ga1s<DCO_T> DCO_TAM;
typedef DCO_TAM::type DCO_TA;
typedef DCO_TAM::tape_t DCO_TAM_TAPE;

int main() {
  vector<DCO_TA> L(n,0.05); DCO_TA P=0;
  srand(0); default_random_engine generator(0);
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> Z(p,vector<double>(m));
  for (int j=0; j<p;j++)
    for (int i=0;i<m;i++)
      Z[j][i]=0.3+distribution(generator);
  DCO_TAM::global_tape=DCO_TAM_TAPE::create();
  DCO_TAM::global_tape->register_variable(L);
  DCO_TAM_TAPE::position_t tpos=DCO_TAM::global_tape->get_position();
  vector<vector<double> > ddPdLL(n,vector<double>(n,0));
  for(int j=0;j<n;j++) {
    dco::derivative(dco::value(L[j]))=1;
    f(L,P,Z);
    DCO_TAM::global_tape->register_output_variable(P);
    dco::value(dco::derivative(P))=1;
    DCO_TAM::global_tape->interpret_adjoint_to(tpos);
    for(int i=0;i<n;i++) {
      ddPdLL[i][j]=dco::derivative(dco::derivative(L[i]));
      dco::derivative(L[i])=0; 
    }
    dco::derivative(dco::value(L[j]))=0;
    DCO_TAM::global_tape->reset_to(tpos);
  }
  DCO_TAM_TAPE::remove(DCO_TAM::global_tape);
  for (int i=0;i<n;i++)
    for (int j=0;j<n;j++)
      cout << "ddP/dL[" << i << "]dL[" << j << "]=" << ddPdLL[i][j] << endl;
  return 0;
}
