#include "std_includes.h"
#include "f.h"

#include "dco.hpp"
typedef dco::ga1s<double> DCO_AM;
typedef typename DCO_AM::type DCO_A;
typedef typename DCO_AM::tape_t DCO_AM_TAPE;

int main() {
  vector<DCO_A> L(n,0.05); DCO_A P=0;
  srand(0); default_random_engine generator(0);
  normal_distribution<double> distribution(0.0,1.0);
  vector<vector<double>> Z(p,vector<double>(m));
  for (int j=0; j<p;j++)
    for (int i=0;i<m;i++)
      Z[j][i]=0.3+distribution(generator);
  DCO_AM::global_tape=DCO_AM_TAPE::create();
  DCO_AM::global_tape->register_variable(L);
  f(L,P,Z);
  DCO_AM::global_tape->register_output_variable(P);
  dco::derivative(P)=1;
  DCO_AM::global_tape->interpret_adjoint();
  vector<double> dPdL(dco::derivative(L)); 
  cerr << dco::size_of(DCO_AM::global_tape) << "B" << endl;
  DCO_AM_TAPE::remove(DCO_AM::global_tape);
  for(int i=0;i<n;i++)
    cout << "dPdL[" << i << "]=" << dPdL[i] << endl;
  return 0;
}
