#include "std_includes.h"
#include "f.h"

template <typename T, int N=Dynamic>
inline void step_t(const int m, const Matrix<T,3,1>& p, Matrix<T,N,1>& y, 
                   Matrix<T,N,1>& y_t) {
  int n=y.size();
  Matrix<T,N,N> A=Matrix<T,N,N>::Zero(n,n); 
  Matrix<T,N,1> y_prev=y;
  newton(m,p,y_prev,y); 
  dfdy(m,p,y,A);
  PartialPivLU<Matrix<T,N,N>> LU(A);
  y_t=LU.solve(y_t); 
}

template <typename T, int N=Dynamic>
inline void f_t(const int m, const Matrix<T,3,1>& p, Matrix<T,N,1>& y, 
                Matrix<T,N,1>& y_t) {
  for (int j=0;j<m;j++) step_t(m,p,y,y_t);
}

int main(int c, char* v[]){
  assert(c==3);
  int n=atoi(v[1]), m=atoi(v[2]);
  Matrix<double,Dynamic,1> y=Matrix<double,Dynamic,1>::Zero(n); 
  Matrix<double,3,1> p=Matrix<double,3,1>::Zero(3); 
  p(0)=1e-3; p(1)=42; p(2)=0;
  for (int j=0;j<n;j++) {
    for (int i=0;i<n;i++) y(i)=(i+1)*log(static_cast<double>(i+2));
    Matrix<double,Dynamic,1> y_t=Matrix<double,Dynamic,1>::Zero(n); 
    y_t(j)=1; 
    f_t(m,p,y,y_t);  
    cout << "dy(n/2)/dy0[" << j << "]=" << y_t(n/2) << endl;
  }
  return 0;
}


