#include "std_includes.h"
#include "f.h"

enum Mode { PRIMAL, AUGMENTED_PRIMAL, SPLIT_ADJOINT };

template <typename T, int N=Dynamic>
inline void step_a(Mode mode, const int m, const Matrix<T,3,1>& p, 
                   Matrix<T,N,1>& y, Matrix<T,N,1>& y_a) {
  static stack<Matrix<T,N,1>> psols;
  int n=y.size();
  Matrix<T,N,N> A=Matrix<T,N,N>::Zero(n,n); 
  switch (mode) {
  case PRIMAL: {
    Matrix<T,N,1> y_prev=y;
    newton(m,p,y_prev,y); 
    break;
  }
  case AUGMENTED_PRIMAL: {
    Matrix<T,N,1> y_prev=y;
    newton(m,p,y_prev,y); 
    psols.push(y);
    break;
  }
  case SPLIT_ADJOINT: {
    y=psols.top(); psols.pop();
    dfdy(m,p,y,A);
    PartialPivLU<Matrix<T,N,N>> LU(A.transpose());
    y_a=-LU.solve(-y_a);
    break;
  }
  }  
}

template <typename T, int N=Dynamic>
inline void f_a(const int m, const int ncs, const Matrix<T,3,1>& p, 
                Matrix<T,N,1>& y, Matrix<T,N,1>& y_a) {
  static stack<Matrix<T,N,1>> cp;
  for (int j=0;j<m-ncs;j+=ncs) {
    cp.push(y);
    for (int i=0;i<ncs;i++) 
      step_a(PRIMAL,m,p,y,y_a);
  }
  for (int i=0;i<ncs;i++) 
    step_a(AUGMENTED_PRIMAL,m,p,y,y_a);
  for (int i=0;i<ncs;i++) 
    step_a(SPLIT_ADJOINT,m,p,y,y_a);
  for (int j=0;j<m-ncs;j+=ncs) {
    y=cp.top(); cp.pop();
    for (int i=0;i<ncs;i++) 
      step_a(AUGMENTED_PRIMAL,m,p,y,y_a);
    for (int i=0;i<ncs;i++) 
      step_a(SPLIT_ADJOINT,m,p,y,y_a);
  }
}

int main(int c, char* v[]){
  assert(c==4);
  int n=atoi(v[1]), m=atoi(v[2]), ncs=atoi(v[3]); assert(m%ncs==0);
  Matrix<double,Dynamic,1> y(n); 
  for (int i=0;i<n;i++) y(i)=(i+1)*log(static_cast<double>(i+2));
  Matrix<double,3,1> p; p(0)=1e-3; p(1)=42; p(2)=0;
  Matrix<double,Dynamic,1> y_a=Matrix<double,Dynamic,1>::Zero(n); 
  y_a(n/2)=1; 
  f_a(m,ncs,p,y,y_a);  
  for(int i=0;i<n;i++)
    cout << "dy(n/2)/dy0[" << i << "]=" << y_a(i) << endl;
  return 0;
}


