#include "std_includes.h"
#include "f.h"

int main(int c, char* v[]){
  assert(c==3);
  int n=atoi(v[1]), m=atoi(v[2]);
  Matrix<double,Dynamic,1> y(n); 
  Matrix<double,3,1> p(3); p(0)=1e-3; p(1)=42; p(2)=0;
  for(int j=0;j<n;j++) {
    for (int i=0;i<n;i++) y(i)=(i+1)*log(static_cast<double>(i+2));
    Matrix<double,Dynamic,1> yph=y, ymh=y;
    double h=(y(j)<1) ? sqrt(DBL_EPSILON) : sqrt(DBL_EPSILON)*abs(y(j));
    ymh(j)-=h; f(m,p,ymh); yph(j)+=h; f(m,p,yph);
    cout << "dy(n/2)/dy0[" << j << "]=" << (yph(n/2)-ymh(n/2))/(2*h) << endl;
  }
  return 0;
}

