#include "std_includes.h"

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;

#include "f.h"

int main(int c, char* v[]){
  assert(c==3);
  int n=atoi(v[1]), m=atoi(v[2]);
  Matrix<DCO_T,Dynamic,1> y(n);
  Matrix<DCO_T,3,1> p; p(0)=1e-3; p(1)=42; p(2)=0;
  for (int j=0;j<n;j++) {
    for (int i=0;i<n;i++) y(i)=(i+1)*log(static_cast<double>(i+2));
    dco::derivative(y(j))=1;
    f(m,p,y);  
    cout << "dy(n/2)/dy0[" << j << "]=" << dco::derivative(y(n/2)) << endl;
  }
  return 0;
}


