#include "std_includes.h"

#include "dco.hpp"
typedef dco::ga1sm<double> DCO_AM;
typedef DCO_AM::type DCO_A;
typedef DCO_AM::tape_t DCO_AM_TAPE;

#include "f.h"

int main(int c, char* v[]){
  assert(c==3);
  int n=atoi(v[1]), m=atoi(v[2]);
  Matrix<DCO_A,Dynamic,1> y0=Matrix<DCO_A,Dynamic,1>::Zero(n); 
  for (int i=0;i<n;i++) y0(i)=(i+1)*log(static_cast<double>(i+2));
  Matrix<DCO_A,3,1> p=Matrix<DCO_A,3,1>::Zero(3); 
  p(0)=1e-3; p(1)=42; p(2)=0;
  DCO_AM_TAPE* tape=DCO_AM_TAPE::create();
  for(int i=0;i<n;i++) tape->register_variable(y0(i));
  Matrix<DCO_A,Dynamic,1> y=y0;
  f(m,p,y);  
  for(int i=0;i<n;i++) tape->register_output_variable(y(i));
  dco::derivative(y(n/2))=1.;
  tape->interpret_adjoint();
  for(int i=0;i<n;i++)
    cout << "dy(n/2)/dy0[" << i << "]=" << dco::derivative(y0(i)) << endl;
  DCO_AM_TAPE::remove(tape);
  return 0;
}


