#include "std_includes.h"

template <typename AT, typename PT>
inline void step_t(const int m, 
  const vector<PT>& p, const vector<PT>& p_t, 
  vector<AT>& y, vector<AT>& y_t) 
{
  int n=y.size();
  vector<AT> r(n), r_t(n);
  int ns=(n+1)*(n+1);
  AT v=p[0]*ns;
  r_t[0]=p_t[0]*ns*(p[1]-2*y[0]+y[1])
        +v*p_t[1]-v*2*y_t[0]+v*y_t[1];
  r[0]=v*(p[1]-2*y[0]+y[1]);
  for (int i=1;i<n-1;i++) {
    r_t[i]=p_t[0]*ns*(y[i-1]-2*y[i]+y[i+1])
          +v*y_t[i-1]-v*2*y_t[i]+v*y_t[i+1];
    r[i]=v*(y[i-1]-2*y[i]+y[i+1]);
  }
  r_t[n-1]=p_t[0]*ns*(y[n-2]-2*y[n-1]+p[2])
          +v*y_t[n-2]-v*2*y_t[n-1]+v*p_t[2];
  r[n-1]=v*(y[n-2]-2*y[n-1]+p[2]);
  for (int i=0;i<n;i++) {
    y_t[i]+=r_t[i]/m;
    y[i]+=r[i]/m;
  }
}

template <typename AT, typename PT>
inline void f_t(const int m, 
  const vector<PT>& p, const vector<PT>& p_t, 
  vector<AT>& y, vector<AT>& y_t) 
{
  for (int j=0;j<m;j++) step_t(m,p,p_t,y,y_t);
}

int main(int c, char* v[]) {
  assert(c==3);
  int n=atoi(v[1]), m=atoi(v[2]);
  vector<double> y(n), y_t(n); 
  vector<double> p={1e-3,42,0}, p_t(3,0);
  for (int j=0;j<n;j++) {
    for (int i=0;i<n;i++) {
      y[i]=(i+1)*log(static_cast<double>(i+2));
      y_t[i]=0;
    }
    y_t[j]=1;
    f_t(m,p,p_t,y,y_t);
    cout << "dy(n/2)/dy0[" << j << "]=" << y_t[n/2] << endl;
  }
  return 0;
}
