#include "std_includes.h"
#include "f.h"

int main(int argc, char* argv[]){
  assert(argc==3);
  int n=atoi(argv[1]), m=atoi(argv[2]);
  vector<double> y(n), p={1e-3,42,0};
  for(int j=0;j<n;j++) {
    for (int i=0;i<n;i++) y[i]=(i+1)*log(static_cast<double>(i+2));
    vector<double> yph=y, ymh=y;
    double h=(y[j]<1) ? sqrt(DBL_EPSILON) : sqrt(DBL_EPSILON)*abs(y[j]);
    ymh[j]-=h; f(m,p,ymh); yph[j]+=h; f(m,p,yph);
    cout << "dy(n/2)/dy0[" << j << "]=" 
         << (yph[n/2]-ymh[n/2])/(2*h) << endl;
  }
  return 0;
}

