#ifndef __F_H_INCLUDED_
#define __F_H_INCLUDED_

template <typename AT, typename PT>
inline void step(const int m, const vector<PT>& p, vector<AT>& y) {
  int n=y.size();
  vector<AT> r(n);
  AT v=p[0]*(n+1)*(n+1);
  r[0]=v*(p[1]-2*y[0]+y[1]);
  for (int i=1;i<n-1;i++) r[i]=v*(y[i-1]-2*y[i]+y[i+1]);
  r[n-1]=v*(y[n-2]-2*y[n-1]+p[2]);
  for (int i=0;i<n;i++) y[i]+=r[i]/m;
}

template <typename AT, typename PT>
inline void f(const int m, const vector<PT>& p, vector<AT>& y) {
  for (int j=0;j<m;j++) step(m,p,y);
}

#endif
