#include "std_includes.h"

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;

#include "f.h"

int main(int argc, char* argv[]){
  assert(argc==3);
  int n=atoi(argv[1]), m=atoi(argv[2]);
  vector<DCO_T> y(n), p={1e-3,42,0};
  for (int j=0;j<n;j++) {
    for (int i=0;i<n;i++) y[i]=(i+1)*log(static_cast<double>(i+2));
    dco::derivative(y[j])=1;
    f(m,p,y);  
    cout << "dy(n/2)/dy0[" << j << "]=" << dco::derivative(y[n/2]) << endl;
  }
  return 0;
}


