#include "std_includes.h"

#include "dco.hpp"
typedef double DCO_BT;
typedef dco::ga1sm<DCO_BT> DCO_AM;
typedef DCO_AM::type DCO_A;
typedef DCO_AM::tape_t DCO_AM_TAPE;

#include "f.h"

int main(int c, char* v[]){
  assert(c==3); int n=atoi(v[1]), m=atoi(v[2]);
  vector<DCO_A> y0(n), p={1e-3,42,0};
  for (int i=0;i<n;i++) y0[i]=(i+1)*log(static_cast<double>(i+2));
  DCO_AM_TAPE* tape=DCO_AM_TAPE::create();
  tape->register_variable(y0);
  vector<DCO_A> y=y0;
  f(m,p,y);  
  tape->register_output_variable(y);
  dco::derivative(y[n/2])=1.;
  tape->interpret_adjoint();
  for(int i=0;i<n;i++)
    cout << "dy(n/2)/dy0[" << i << "]=" << dco::derivative(y0[i]) << endl;
  DCO_AM_TAPE::remove(tape);
  return 0;
}


