# include "std_includes.h"
# include "f.h"

typedef Matrix<double,Dynamic,1> VT;

VT driver(VT& u, double e, double r, double sigma, int nt) {
  int nx=u.size()+1;
  VT g(nx+2); 
  VT u0=u;
  f(u,e,r,sigma,nt);
  VT u_(nx-1); double h;
  // Delta
  for (int i=0;i<nx-1;i++) {
    for (int j=0;j<nx-1;j++) u_[j]=u0[j];
    h=(u_[i]<1) ? sqrt(DBL_EPSILON) : sqrt(DBL_EPSILON)*abs(u_[i]);  
    u_[i]+=h;
    f(u_,e,r,sigma,nt);
    g[i]=(u_[(nx-1)/2]-u[(nx-1)/2])/h;
  }
  // ???
  for (int j=0;j<nx-1;j++) u_[j]=u0[j];
  h=(e<1) ? sqrt(DBL_EPSILON) : sqrt(DBL_EPSILON)*abs(e);  
  e+=h;
  f(u_,e,r,sigma,nt);
  g[nx-1]=(u_[(nx-1)/2]-u[(nx-1)/2])/h;
  e-=h;
  // Rho
  for (int j=0;j<nx-1;j++) u_[j]=u0[j];
  h=(r<1) ? sqrt(DBL_EPSILON) : sqrt(DBL_EPSILON)*abs(r);  
  r+=h;
  f(u_,e,r,sigma,nt);
  g[nx]=(u_[(nx-1)/2]-u[(nx-1)/2])/h;
  r-=h;
  // Vega
  for (int j=0;j<nx-1;j++) u_[j]=u0[j];
  h=(sigma<1) ? sqrt(DBL_EPSILON) : sqrt(DBL_EPSILON)*abs(sigma);  
  sigma+=h;
  f(u_,e,r,sigma,nt);
  g[nx+1]=(u_[(nx-1)/2]-u[(nx-1)/2])/h;
  return g;
}  

int main(int c, char* v[]) {
  assert(c==3); int nx=atoi(v[1]), nt=atoi(v[2]);
  const double e=0.5, r=0.03, sigma=0.5;
  assert(nt>sigma*sigma*nx*nx);
  assert(nt>(r*r)/(sigma*sigma));
  VT u(nx-1); double u0=0;
  for (int i=0;i<nx-1;i++) { u0=u0+1./nx; u[i]=max(u0-e,0.); }
  VT greeks=driver(u,e,r,sigma,nt);
  for (int i=0;i<nx-1;i++) 
    cout << "dVdu0[" << (i+1)*1./(nx-1) << "]=" << greeks[i] << endl;
  cout << "dVde=" << greeks[nx-1] << endl;
  cout << "dVdr=" << greeks[nx] << endl;
  cout << "dVdsigma=" << greeks[nx+1] << endl;
  return 0;
}

