#pragma once

#include "std_includes.h"

#include "Eigen/Dense"
using namespace Eigen;

template<typename T, int N=Dynamic>
void f(Matrix<T,N,1>& u, T e, T r, T sigma, int nt) {
  int nx=u.size()+1;
  double dt=1./nt;
  
  Matrix<T,N,1> u_new(u.size());
  for (int j=0;j<nt;j++) {
    double t=j*dt;

    u_new[0]=u[0]+dt*(
      0.5*pow(sigma*(0+1),2)*(u[0+1]-2*u[0]+/*=u[0-1]=*/0/**/)+
      0.5*r*(0+1)*(u[0+1]-/*u[0-1]=*/0/**/)-r*u[0]);
    for (int i=1;i<nx-2;i++) 
      u_new[i]=u[i]+dt*
        (0.5*pow(sigma*(i+1),2)*(u[i+1]-2*u[i]+u[i-1])+
        0.5*r*(i+1)*(u[i+1]-u[i-1])-r*u[i]);
    u_new[nx-2]=u[nx-2]+dt*(
      0.5*pow(sigma*(nx-2+1),2)*(/*u[nx-2+1]=*/1-e*exp(-r*t)/**/-2*u[nx-2]+u[nx-2-1])+
      0.5*r*(nx-2+1)*(/*u[nx-2+1]=*/1-e*exp(-r*t)/**/-u[nx-2-1])-r*u[nx-2]);
    u=u_new;
  }
}
