# include "std_includes.h"
# include "f.h"

int main(int c, char* v[]) {
  assert(c==3); int nx=atoi(v[1]), nt=atoi(v[2]); 
  const double e=0.5, r=0.03, sigma=0.5;
  assert(nt>sigma*sigma*nx*nx);
  assert(nt>(r*r)/(sigma*sigma));
  // const double s0=0.3; cout << analytic(s0,e,r,sigma) << endl;
  Matrix<double,Dynamic,1> u(nx-1); double u0=0;
  for (int i=0;i<nx-1;i++) { u0=u0+1./nx; u[i]=max(u0-e,0.); }

  f(u,e,r,sigma,nt);
  for (int i=0;i<nx-1;i++) cout << (i+1)*1./(nx-1) << " " << u[i] << endl;
  return 0;
}

