# include "std_includes.h"
# include "f.h"

#include "dco.hpp"
typedef dco::gt1s<double>::type DCO_T;

typedef Matrix<DCO_T,Dynamic,1> DCO_VT;
typedef Matrix<double,Dynamic,1> VT;


VT driver(const VT& u, double e, double r, double sigma, int nt) {
  int nx=u.size()+1;
  VT g(nx+2); 
  DCO_VT u_(nx-1); 
  DCO_T e_=e, r_=r, sigma_=sigma; 
  // Delta
  for (int i=0;i<nx-1;i++) {
    for (int j=0;j<nx-1;j++) u_[j]=u[j];
    dco::derivative(u_[i])=1;
    f(u_,e_,r_,sigma_,nt);
    g[i]=dco::derivative(u_[(nx-1)/2]);
  }
  // ???
  for (int j=0;j<nx-1;j++) u_[j]=u[j];
  dco::derivative(e_)=1;
  f(u_,e_,r_,sigma_,nt);
  g[nx-1]=dco::derivative(u_[(nx-1)/2]);
  dco::derivative(e_)=0; 
  // Rho
  for (int j=0;j<nx-1;j++) u_[j]=u[j];
  dco::derivative(r_)=1;
  f(u_,e_,r_,sigma_,nt);
  g[nx]=dco::derivative(u_[(nx-1)/2]);
  dco::derivative(r_)=0; 
  // Vega
  for (int j=0;j<nx-1;j++) u_[j]=u[j];
  dco::derivative(sigma_)=1;
  f(u_,e_,r_,sigma_,nt);
  g[nx+1]=dco::derivative(u_[(nx-1)/2]);
  return g;
}  

int main(int c, char* v[]) {
  assert(c==3); int nx=atoi(v[1]), nt=atoi(v[2]);
  const double e=0.5, r=0.03, sigma=0.5;
  assert(nt>sigma*sigma*nx*nx);
  assert(nt>(r*r)/(sigma*sigma));
  VT u(nx-1); double u0=0;
  for (int i=0;i<nx-1;i++) { u0=u0+1./nx; u[i]=max(u0-e,0.); }
  VT greeks=driver(u,e,r,sigma,nt);
  for (int i=0;i<nx-1;i++) 
    cout << "dVdu0[" << (i+1)*1./(nx-1) << "]=" << greeks[i] << endl;
  cout << "dVde=" << greeks[nx-1] << endl;
  cout << "dVdr=" << greeks[nx] << endl;
  cout << "dVdsigma=" << greeks[nx+1] << endl;
  return 0;
}

