# include "std_includes.h"
# include "f.h"

#include "dco.hpp"
typedef dco::ga1s<double> DCO_AM;
typedef DCO_AM::type DCO_A;
typedef DCO_AM::tape_t DCO_AM_TAPE;

typedef Matrix<DCO_A,Dynamic,1> DCO_VT;
typedef Matrix<double,Dynamic,1> VT;

VT driver(const VT& u, double e, double r, double sigma, int nt) {
  int nx=u.size()+1;
  VT g(nx+2); 
  DCO_VT u0_(nx-1); 
  for (int j=0;j<nx-1;j++) u0_[j]=u[j];
  DCO_A e_=e, r_=r, sigma_=sigma; 
  DCO_AM::global_tape=DCO_AM_TAPE::create();
  for (int j=0;j<nx-1;j++) 
    DCO_AM::global_tape->register_variable(u0_[j]);
  DCO_AM::global_tape->register_variable(e_);
  DCO_AM::global_tape->register_variable(r_);
  DCO_AM::global_tape->register_variable(sigma_);
  DCO_VT u_=u0_;
  f(u_,e_,r_,sigma_,nt);
  for (int j=0;j<nx-1;j++) 
    DCO_AM::global_tape->register_output_variable(u_[j]);
  dco::derivative(u_[(nx-1)/2])=1;
  DCO_AM::global_tape->interpret_adjoint();
  // Delta
  for (int j=0;j<nx-1;j++) 
    g[j]=dco::derivative(u0_[j]);
  // ???
  g[nx-1]=dco::derivative(e_);
  // Rho
  g[nx]=dco::derivative(r_);
  // Vega
  g[nx+1]=dco::derivative(sigma_);
  return g;
}  

int main(int c, char* v[]) {
  assert(c==3); int nx=atoi(v[1]), nt=atoi(v[2]);
  const double e=0.5, r=0.03, sigma=0.5;
  assert(nt>sigma*sigma*nx*nx);
  assert(nt>(r*r)/(sigma*sigma));
  VT u(nx-1); double u0=0;
  for (int i=0;i<nx-1;i++) { u0=u0+1./nx; u[i]=max(u0-e,0.); }
  VT greeks=driver(u,e,r,sigma,nt);
  for (int i=0;i<nx-1;i++) 
    cout << "dVdu0[" << (i+1)*1./(nx-1) << "]=" << greeks[i] << endl;
  cout << "dVde=" << greeks[nx-1] << endl;
  cout << "dVdr=" << greeks[nx] << endl;
  cout << "dVdsigma=" << greeks[nx+1] << endl;
  return 0;
}

